<?php
  session_start();
  
  include 'constants.php';

  $host = 'localhost';
  $baza = 'testphp';
  $uzytkownik = "php";
  $haslo = "test";

  function addUser($nazwa, $pass, $pass2, $imie, $nazwisko, $email){
    //Umoliwienie odwoa do zmiennych globalnych
    global $host, $baza, $uzytkownik, $haslo;

    //Sprawdzenie poprawnoci danych (dugo).
    //Dla kodowania jednobajtowego
    //$userPassLength = strlen($pass);
    //Dla kodowania utf-8
    //$userPassLength = strlen(utf8_decode($pass));
    //lub:
    $userPassLength = mb_strlen($pass, 'UTF-8');

    //Za dugo hasa
    if($userPassLength < 6 || $userPassLength > 40){
      return INVALID_USER_PASS;
    }
    
    //Powtrzenie hasa rne od oryginau
    if($pass != $pass2){
      return PASSWORDS_DO_NOT_MATCH;
    }

    if($imie == "" || $nazwisko == "" || $email == ""){
      return EMPTY_FIELDS;
    }

    //Sprawdzenie poprawnoci danych (wyraenia regularne)
    if(!preg_match("/^[a-zA-Z0-9_.]{3,20}$/", $nazwa)){
      return INVALID_USER_NAME;
    };
    
    //Tutaj ewentualne dalsze instrukcje weryfikujce dane

    //Nawizanie poczenia z baz danych
    $db_obj = new mysqli($host, $uzytkownik, $haslo, $baza);
    if($db_obj->connect_errno){
      //echo 'Wystpi bd podczas prby poczenia z serwerem MySQL...';
      //echo $db_obj->connect_error;
      return SERVER_ERROR;
    }

    //Zabezpieczenie znakw specjalnych w parametrach
    $nazwa = $db_obj->real_escape_string($nazwa);
    $imie = $db_obj->real_escape_string($imie);
    $nazwisko = $db_obj->real_escape_string($nazwisko);
    $email = $db_obj->real_escape_string($email);
    
    //Sprawdzenie, czy uytkownik o podanej nazwie istnieje w bazie.
    $query = "SELECT COUNT(*) FROM Users WHERE Nazwa='$nazwa' ";

    if(!$result = $db_obj->query($query)){
      //echo 'Wystpi bd: nieprawidowe zapytanie...';
      $db_obj->close();
      return SERVER_ERROR;
    }

    if(!$row = $result->fetch_row()){
      //echo('Wystpi bd: nieprawidowe wyniki zapytania...');
      $db_obj->close();
      return SERVER_ERROR;
    }
    else{
      //Uytkownik istnieje, nie mona doda nowego wpisu do bazy.
      if($row[0] > 0){
        $db_obj->close();
        return USER_NAME_ALREADY_EXISTS;
      }
    }
    
    //Dodanie nowego uytkownika
    $pass = crypt($pass);
    
    $query = "INSERT INTO Users VALUES(";
    $query .= "NULL, '$nazwa', '$pass', '$imie', '$nazwisko', '$email')";

    if(!$result = $db_obj->query($query)){
      //echo('Wystpi bd: instrukcja INSERT...');
      $db_obj->close();
      return SERVER_ERROR;
    }

    //Pobranie liczby dodanych rekordw
    $count = $db_obj->affected_rows;

    if($count <> 1){
      //Niewaciwe wyniki zapytania
      $db_obj->close();
      return SERVER_ERROR;
    }
    else{
      //Prawidowe dodanie rekordu
      $db_obj->close();
      return OK;
    }    
  }
  
  //Sprawdzenie, czy uytkownik jest ju zalogowany.
  if(isset($_SESSION['zalogowany'])){
    header("Location: main.php");
  }
  //Sprawdzenie, czy zostay przekazane wszystkie pola formularza.
  else if(!isset($_POST["nazwa"]) || !isset($_POST["haslo"]) ||
          !isset($_POST["haslo2"]) || !isset($_POST["imie"]) ||
          !isset($_POST["nazwisko"]) || !isset($_POST["email"])){
    header('Location:new_user_form.php');
  }
  else{
    //Odczytanie danych z formularza
    $nazwa = $_POST["nazwa"];
    $pass = $_POST["haslo"];
    $pass2 = $_POST["haslo2"];
    $imie = $_POST["imie"];
    $nazwisko = $_POST["nazwisko"];
    $email = $_POST["email"];

    //Wywoanie funkcji rejestrujcej nowego uytkownika
    $val = addUser($nazwa, $pass, $pass2, $imie, $nazwisko, $email);

    //Reakcja na warto zwrcon przez funkcj
    switch($_SESSION['kod'] = $val){
      case OK :
        $_SESSION['komunikat'] = "Rejestracja poprawna.";
        break;
      case INVALID_USER_NAME :
        $_SESSION['komunikat'] = 
          "Nazwa uytkownika musi mie od 3 do 20 znakw i " .
          "moe zawiera jedynie znaki alfabetu aciskiego " . 
          "oraz cyfry i znaki podkrelenia.";
        break;
      case INVALID_USER_PASS :
        $_SESSION['komunikat'] = "Haso musi mie od 6 do 40 znakw.";
        break;
      case USER_NAME_ALREADY_EXISTS :
        $_SESSION['komunikat'] = 
          "Uytkownik $nazwa jest ju zarejestrowany.";
        break;
      case EMPTY_FIELDS :
        $_SESSION['komunikat'] = 
          "Prosz wypeni wszystkie wymagane pola formularza.";
        break;
      case PASSWORDS_DO_NOT_MATCH :
        $_SESSION['komunikat'] = 
          "Wpisane hasa rni si.";
        break;
      default:
        $_SESSION['komunikat'] = 
          "Bd serwera. Rejestracja nie powioda si.";
    }
    
    header('Location: after_registration.php');
  }
?>
